/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1986 - 2000 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
/*
 * Name:
 *	SPInterface.h
 *
 *
 * Purpose:
 *	SP Interface Suite
 *
 * Distribution:
 *	PUBLIC
 *
 * Version history:
 *	1.0.0 4/1/1995	DL	First version.
 *		Created by Adobe Systems Incorporated.
 */

#ifndef __SPInterface__
#define __SPInterface__


/*******************************************************************************
 **
 **	Imports
 **
 **/

#include "SPTypes.h"
#include "SPBasic.h"
#include "SPFiles.h"
#include "SPMData.h"
#include "SPPlugs.h"
#include "SPProps.h"

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************************************
 **
 ** Constants
 **
 **/

#define kSPInterfaceSuite				"SP Interface Suite"
#define kSPInterfaceSuiteVersion		2

#define kSPInterfaceCaller				"SP Interface"
#define kSPInterfaceStartupSelector		"Startup"
#define kSPInterfaceShutdownSelector	"Shutdown"
#define kSPInterfaceAboutSelector		"About"

#define kSPSweetPea2Adapter				"Sweet Pea 2 Adapter"
#define kSPSweetPea2AdapterVersion		1

/*******************************************************************************
 **
 ** Types
 **
 **/

typedef struct SPInterfaceMessage {

	SPMessageData d;
	
} SPInterfaceMessage;


/*******************************************************************************
 **
 ** Suite
 **
 **/

typedef struct SPInterfaceSuite {

	SPAPI SPErr (*SendMessage)( SPPluginRef plugin, char *caller, char *selector, void *message, SPErr *result );
	SPAPI SPErr (*SetupMessageData)( SPPluginRef plugin, SPMessageData *data );
	SPAPI SPErr (*EmptyMessageData)( SPPluginRef plugin, SPMessageData *data );
	SPAPI SPErr (*StartupExport)( SPPluginListRef pluginList, char *name, long version, long *started );

} SPInterfaceSuite;


SPAPI SPErr SPSendMessage( SPPluginRef plugin, char *caller, char *selector, void *message, SPErr *result );
SPAPI SPErr SPSetupMessageData( SPPluginRef plugin, SPMessageData *data );
SPAPI SPErr SPEmptyMessageData( SPPluginRef plugin, SPMessageData *data );
SPAPI SPErr SPStartupExport( SPPluginListRef pluginList, char *name, long version,long *started );


/*******************************************************************************
 **
 ** Errors
 **
 **/

#include "SPErrorCodes.h"

#ifdef __cplusplus
}
#endif

#endif
